using System.Security.Authentication.ExtendedProtection;

namespace BallDemo
{
    public class Game
    {
        private IList<IObject> objects;
        private Random random;

        public Game()
        {
            this.random = new Random();
            this.objects = new List<IObject>();
        }

        public IList<IObject> GetObjects(int tick)
        {
            decimal time = (decimal)tick / Demo.RefreshRate;
            if (time == 0)
            {
                this.objects.Add(new TextObject()
                {
                    Text = "Brownbirdie 2025",
                    pos = new(Demo.Width, this.random.Next(Demo.Height - 1)),
                    Speed = 1,
                });
            }
            if (time == 5)
            {
                this.objects.Add(new Ball()
                {
                    pos = new(3, Demo.Height / 4 ),
                    vector = new(1, 1),
                    // vector = new(1, Speed(3)),
                    size = 3,
                    Time = 15,
                });
            }
            if(new[] {20, 30,50,60, }.Any(x => x == time))
            {
                this.objects.Add(this.RandomBall());
            }
            if (time == 30)
            {
                this.objects.Add(new TextObject()
                {
                    Text = @"Kwarf / MemoryLeek; Znurre / MemoryLeek; michan; BKC / nissoC; zelest; LokasNt; dunz0r / fACERAPE; hypeRUNKnown / Noice; xinux / MemoryLeek; Hevosenliha; Barbie / hARDkORE lAMERz; h4xxel / //achtung fulkod; slaeshjag / //achtung fulkod; brutusmcforce; BingBong; Fsfreak / Hvc,flt,ppkno,jkrz; MIHI / MemoryLeek; Wix; 1080p / withdrawal; DeTvå / MemoryLeek; zer0Page; MNTM587 / Smiley; AntDude / Antipathic Dudes; Megastierna; Nytamin;",
                    pos = new(Demo.Width, this.random.Next(Demo.Height - 1)),
                    Speed = 1,
                });
            }
            if (time > 40 && time < 60 && time % 2 == 0)
            {
                for (int i = 0; i < 7; i++)
                {
                    this.objects.Add(new TextObject()
                    {
                        Text = @"Sa du boll?",
                        pos = new(this.random.Next(Demo.Width), this.random.Next(Demo.Height - 1)),
                        Speed = 2,
                    });
                }
            } 
            if (time > 60 && time % 2 == 0)
            {
                for(int i = 0; i < 7;i++)
                {
                    this.objects.Add(new TextObject()
                    {
                        Text = @"Bollar är fan bäst!",
                        pos = new(this.random.Next(Demo.Width), this.random.Next(Demo.Height - 1)),
                        Speed = 2,
                    });
                }
            }
            if (time > 50 && time % 3 == 0)
            {
                this.objects.Add(this.RandomBall());
            }
            if (time > 65 && time % 2 == 0)
            {
                this.objects.Add(this.RandomBall());
            }
            if(time > 80 && time % 2 == 0)
            {
                this.objects.Add(this.RandomBall());
            }
            var objectstoRemove = this.objects.Where(x => x.Time < 0).ToList();
            foreach (IObject obj in objectstoRemove)
            {
                this.objects.Remove(obj);
            }
            return this.objects;
        }

        private Ball RandomBall()
        {
            return new Ball()
            {
                pos = this.RandomPos(),
                vector = this.RandomVector(),
                size = this.random.Next(3)+1,
                Time = 15,
            };
        }
        
        decimal DirectionChange(decimal number)
        {
            if (this.random.Next(100) > 80)
            {
                return number * -1;
            }
            return number;
        }

        (decimal x, decimal y) RandomPos()
        {
            var x = GetNumberWithinBounds(Demo.Width);
            var y = GetNumberWithinBounds(Demo.Height);
            return new(x, y);
        }
        decimal GetNumberWithinBounds(int max)
        {
            var number = this.random.Next(max-2);
            if (number < 2)
            {
                return GetNumberWithinBounds(max);
            }
            return number;
        }
        (decimal x, decimal y) RandomVector()
        {
            return new(DirectionChange( this.random.Next(300) / 100), DirectionChange(this.random.Next(300) / 100));
        }
        private decimal Speed(int max)
        {
            var random = new Random();
            return random.Next(max * 100) / 100;
        }
    }
}
